/* 
 *  Executor.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import com.avaya.ccs.javafxrefclient.request.Request;

import javafx.concurrent.Task;

public class Executor {

    private static ExecutorService clientIncomingEventExecutor;
    private static ExecutorService clientOutgoingRequestExecutor;

    private static ClientSessionExecutor clientSession;
    private static UserExecutor user;
    private static ResourceExecutor resource;
    private static InteractionExecutor interactionExe;
    private static CustomerExecutor customerExe;
    private static MonitoredExecutor monitored;

    public Executor() {
        //Create the executor which will handle events coming in from the SDK
        clientIncomingEventExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            t.setName("incomingEvent");
            t.setDaemon(true); // allows app to exit if tasks are running
            return t;
        });

        //Create the executor which will handle requests going out to the SDK
        clientOutgoingRequestExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            t.setName("outgoingRequest");
            t.setDaemon(true); // allows app to exit if tasks are running
            return t;
        });
    }

    public static void createExecutors(JavaFXRefClient gui) {
        clientSession = new ClientSessionExecutor(gui);
        user = new UserExecutor(gui);
        resource = new ResourceExecutor(gui);
        interactionExe = new InteractionExecutor(gui);
        monitored = new MonitoredExecutor(gui);
        customerExe=new CustomerExecutor(gui);
    }

    public static ClientSessionExecutor getClientSession() {
        return clientSession;
    }

    public static UserExecutor getUser() {
        return user;
    }

    public static ResourceExecutor getResource() {
        return resource;
    }

    public static InteractionExecutor getInteractionExe() {
        return interactionExe;
    }
    
    public static CustomerExecutor getCustomerExe() {
        return customerExe;
    }

    public static MonitoredExecutor getMonitored() {
        return monitored;
    }

    protected void executeIncomingEvent(@SuppressWarnings("rawtypes") Task t) {
        clientIncomingEventExecutor.execute(t);
    }

    protected void executeOutgoingRequest(Request t) {
        clientOutgoingRequestExecutor.execute(t);
    }

    public static void close() {
        clientIncomingEventExecutor.shutdownNow();
        clientOutgoingRequestExecutor.shutdownNow();
    }
}
